# Configure Suricata

This version of Suricata can be modified depending on the flags passed during the configuration phase, you can modify the `openwrt/feeds/packages/net/suricata/Makefile` (enabling/disabling the flags manually) or you can run the `suricata-configure.sh` script that runs Suricata on the remote machine and, depending on the `eve.json` log, reinstall a modified configuration (works with only certain flags).

## List of flags
About the list of all defined flags i suggest you look at `DefinedFlags` file.

---

## Dynamically configure Suricata

### Prerequisites 
1) Device with OpenWrt and Suricata already installed and accessible via ssh
2) OpenWrt repository cloned and preconfigured (as described above)

### List of flags that can be dyncamically set

1) network
2) communication
3) auth
4) rdp
5) mqtt
6) dcerpc
7) ike
8) modbus
9) pgsql
10) quic
11) rfb
12) tftp

### How To
First, place the `suricata-configure.sh` and `suricata-log-parser.py` scripts in the same directory as the OpenWrt cloned repo. 
Then run `suricata-configure.sh` script with:

```bash
./suricata-configure.sh <REMOTE_IP> <REMOTE_PASSWORD> <LOCAL_DESTINATION_PATH> <SURICATA_INTERFACE> <PROTOCOL_THRESHOLD> <SLEEP_TIME> <MAKEFILE_PATH>
```
with:
- `REMOTE_IP` = IP address of OpenWrt device.
- `REMOTE_PASSWORD` = root password (default: admin).
- `LOCAL_DESTINATION_PATH` = path to directory on the host machine where to copy `eve.json` log.
- `SURICATA_INTERFACE` = Suricata Interface to scan
- `PROTOCOL_THRESHOLD` = minimum number of log entries for protocol to enable it
- `SLEEP_TIME` = how many seconds to sniff 
- `MAKEFILE_PATH` = path to the directory of the Makefile of Suricata's OpenWrt package   

This will start Suricata, wait for `SLEEP_TIME` and the stop it (NOTE: it will delete previous `eve.json`), after that it will transfer, via SCP, the log to the host machine.
This log is given to the `suricata-log-parser.py` script that will read each entry and update the counter of the respective flag, then it will compare with the `PROTOCOL_THRESHOLD` and generate the flags for the compilation.
After that, the Makefile of Suricata package will be modified with the output of the python script and then the Suricata package will be recompiled.
The script will move the new-generated packet to the remove device and reinstall it.

---
